Option Strict Off
Option Explicit On
Module Cmmsdk
	' --------------------------------------------------------------
	'            Copyright (C) 2000-2008 COMIZOA Co., LTD.          
	' --------------------------------------------------------------
	
	' DATE  : 2008-08-22
	' TIME  : 16:22:01
	
	'******************************************************************************
	'* [ CmmsdkDef.h ]
	'* Header file for definitions of constants and data in CMMSDK library
	'* - Update Data: 2007/01/12
	'* - Provider: COMIZOA Co., Ltd.
	'* - Phone: +82-42-936-6500~6
	'* - Fax  : +82-42-936-6507
	'* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
	'*******************************************************************************
	
	'*******************************************************************************
	
	' Device ID definition
	Public Const COMI_SD401 As Integer = &HB401
	Public Const COMI_SD402 As Integer = &HB402
	Public Const COMI_SD403 As Integer = &HB403
	Public Const COMI_SD404 As Integer = &HB404
	Public Const COMI_SD414 As Integer = &HB414
	Public Const COMI_SD424 As Integer = &HB424
	Public Const COMI_LX501 As Integer = &HA501
	Public Const COMI_LX502 As Integer = &HA502
	Public Const COMI_LX504 As Integer = &HA504
	Public Const COMI_LX508 As Integer = &HA508
	Public Const COMI_LX534 As Integer = &HA534
	Public Const COMI_LX544 As Integer = &HA544
	Public Const COMI_LX504A As Integer = &HA544
	
	' Definition of maximum number of things
	Public Const CMM_MAX_NUM_MOT_DEV As Short = 16
	' Maximum number of Motion Devices in one PC
	Public Const CMM_MAX_NUM_DIO_DEV As Short = 16
	' Maximum number of Digital I/O Devices in one PC
	Public Const CMM_MAX_NUM_AXES As Short = 64
	' Maximum number of motion axes
	Public Const CMM_MAX_DI_CH As Short = 512
	' Maximum number of D/I channels
	Public Const CMM_MAX_DO_CH As Short = 512
	' Maximum number of D/O channels
	Public Const CMM_MAX_STR_LEN_AXIS_TITLE As Short = 30
	' Maximum string length of axis title
	Public Const CMM_MAX_STR_LEN_DIST_UNIT As Short = 30
	' Maximum string length of distance unit
	Public Const CMM_MAX_STR_LEN_VEL_UNIT As Short = 30
	' Maximum string length of velocity unit
	Public Const CMM_MAX_STR_LEN_ERR As Short = 128
	' Maximum error string length: a buffer to receive error string must be larger than this size.
	
	' Motion Chip Main-space Address
	Public Const COMW As Short = 0
	Public Const OTPW As Short = 1
	Public Const BUF0 As Short = 2
	Public Const BUF1 As Short = 3
	Public Const MSTSW As Short = 0
	Public Const SSTSW As Short = 1
	
	' Motion Chip Registers
	
	Public Const PRMV As Short = 0
	Public Const PRFL As Short = 1
	Public Const PRFH As Short = 2
	Public Const PRUR As Short = 3
	Public Const PRDR As Short = 4
	Public Const PRMG As Short = 5
	Public Const PRDP As Short = 6
	Public Const PRMD As Short = 7
	Public Const PRIP As Short = 8
	Public Const PRUS As Short = 9
	Public Const PRDS As Short = 10
	Public Const PRCP5 As Short = 11
	Public Const PRCI As Short = 12
	
	Public Const RMV As Short = 16
	Public Const RFL As Short = 17
	Public Const RFH As Short = 18
	Public Const RUR As Short = 19
	Public Const RDR As Short = 20
	Public Const RMG As Short = 21
	Public Const RDP As Short = 22
	Public Const RMD As Short = 23
	Public Const RIP As Short = 24
	Public Const RUS As Short = 25
	Public Const RDS As Short = 26
	Public Const RFA As Short = 27
	Public Const RENV1 As Short = 28
	Public Const RENV2 As Short = 29
	Public Const RENV3 As Short = 30
	Public Const RENV4 As Short = 31
	Public Const RENV5 As Short = 32
	Public Const RENV6 As Short = 33
	Public Const RENV7 As Short = 34
	
	Public Const RCUN1 As Short = 35
	Public Const RCUN2 As Short = 36
	Public Const RCUN3 As Short = 37
	Public Const RCUN4 As Short = 38
	Public Const RCMP1 As Short = 39
	Public Const RCMP2 As Short = 40
	Public Const RCMP3 As Short = 41
	Public Const RCMP4 As Short = 42
	Public Const RCMP5 As Short = 43
	Public Const RIRQ As Short = 44
	Public Const RLTC1 As Short = 45
	Public Const RLTC2 As Short = 46
	Public Const RLTC3 As Short = 47
	Public Const RLTC4 As Short = 48
	
	Public Const RSTS As Short = 49
	Public Const REST As Short = 50
	Public Const RIST As Short = 51
	Public Const RPLS As Short = 52
	Public Const RSPD As Short = 53
	Public Const PSDC As Short = 54
	
	Public Const RCI As Short = 60
	Public Const RCIC As Short = 61
	
	Public Const RIPS As Short = 63
	
	
	'***********************************************************************************************
	
	'                                                               CONSTATNS for User                                                                                              *
	
	'***********************************************************************************************
	
	' Boolean type definition
	
	Public Const cmFALSE As Short = 0
	Public Const cmTRUE As Short = 1
	
	
	'/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	' MIO Property ID
	
	' <TCmMioPropId>  <TCmMioPropIdEx>   MIO Property ID Ÿ Դϴ. <TCmMioPropIdEx> 
	
	' <TCmMioPropId>  ̸ ٲپ Դϴ.     ߿ ƹų ص ˴ϴ.
	
	Public Const cmALM_LOGIC As Short = 0
	Public Const cmALM_MODE As Short = 1
	Public Const cmCMP_LOGIC As Short = 2
	Public Const cmDR_LOGIC As Short = 3
	Public Const cmEL_LOGIC As Short = 4
	Public Const cmEL_MODE As Short = 5
	Public Const cmERC_LOGIC As Short = 6
	Public Const cmERC_OUT As Short = 7
	Public Const cmEZ_LOGIC As Short = 8
	Public Const cmINP_EN As Short = 9
	Public Const cmINP_LOGIC As Short = 10
	Public Const cmLTC_LOGIC As Short = 11
	Public Const cmLTC_LTC2SRC As Short = 12
	Public Const cmORG_LOGIC As Short = 13
	Public Const cmSD_EN As Short = 14
	Public Const cmSD_LOGIC As Short = 15
	Public Const cmSD_LATCH As Short = 16
	Public Const cmSD_MODE As Short = 17
	Public Const cmSTA_MODE As Short = 18
	Public Const cmSTA_TRG As Short = 19
	Public Const cmSTP_MODE As Short = 20
	Public Const cmCLR_CNTR As Short = 21
	Public Const cmCLR_SIGTYPE As Short = 22
	Public Const cmCMP_PWIDTH As Short = 23
	Public Const cmERC_ONTIME As Short = 24
	Public Const cmSVON_LOGIC As Short = 25
	Public Const cmERC_OUT_EL As Short = 26
	Public Const cmCNT_D_SRC As Short = 27
	Public Const cmCNT_G_SRC As Short = 28
	
	
	Public Const cmMPID_ALM_LOGIC As Short = 0
	Public Const cmMPID_ALM_MODE As Short = 1
	Public Const cmMPID_CMP_LOGIC As Short = 2
	Public Const cmMPID_DR_LOGIC As Short = 3
	Public Const cmMPID_EL_LOGIC As Short = 4
	Public Const cmMPID_EL_MODE As Short = 5
	Public Const cmMPID_ERC_LOGIC As Short = 6
	Public Const cmMPID_ERC_OUT As Short = 7
	Public Const cmMPID_EZ_LOGIC As Short = 8
	Public Const cmMPID_INP_EN As Short = 9
	Public Const cmMPID_INP_LOGIC As Short = 10
	Public Const cmMPID_LTC_LOGIC As Short = 11
	Public Const cmMPID_LTC_LTC2SRC As Short = 12
	Public Const cmMPID_ORG_LOGIC As Short = 13
	Public Const cmMPID_SD_EN As Short = 14
	Public Const cmMPID_SD_LOGIC As Short = 15
	Public Const cmMPID_SD_LATCH As Short = 16
	Public Const cmMPID_SD_MODE As Short = 17
	Public Const cmMPID_STA_MODE As Short = 18
	Public Const cmMPID_STA_TRG As Short = 19
	Public Const cmMPID_STP_MODE As Short = 20
	Public Const cmMPID_CLR_CNTR As Short = 21
	Public Const cmMPID_CLR_SIGTYPE As Short = 22
	Public Const cmMPID_CMP_PWIDTH As Short = 23
	Public Const cmMPID_ERC_ONTIME As Short = 24
	Public Const cmMPID_SVON_LOGIC As Short = 25
	Public Const cmMPID_ERC_OUT_EL As Short = 26
	Public Const cmMPID_CNT_D_SRC As Short = 27
	Public Const cmMPID_CNT_G_SRC As Short = 28
	
	
	' Bit order of StReadMioStatuses() return value
	
	Public Const cmIOST_RDY As Short = 0
	Public Const cmIOST_ALM As Short = 1
	Public Const cmIOST_ELP As Short = 2
	Public Const cmIOST_ELN As Short = 3
	Public Const cmIOST_ORG As Short = 4
	Public Const cmIOST_DIR As Short = 5
	Public Const cmIOST_RSV1 As Short = 6
	Public Const cmIOST_PCS As Short = 7
	Public Const cmIOST_ERC As Short = 8
	Public Const cmIOST_EZ As Short = 9
	Public Const cmIOST_CLR As Short = 10
	Public Const cmIOST_LTC As Short = 11
	Public Const cmIOST_SD As Short = 12
	Public Const cmIOST_INP As Short = 13
	Public Const cmIOST_DRP As Short = 14
	Public Const cmIOST_DRN As Short = 15
	Public Const cmIOST_STA As Short = 16
	Public Const cmIOST_STP As Short = 17
	
	
	' Motion operation status ID
	
	Public Const cmMST_STOP As Short = 0
	Public Const cmMST_WAIT_DR As Short = 1
	Public Const cmMST_WAIT_STA As Short = 2
	Public Const cmMST_WAIT_INSYNC As Short = 3
	Public Const cmMST_WAIT_OTHER As Short = 4
	Public Const cmMST_WAIT_ERC As Short = 5
	Public Const cmMST_WAIT_DIR As Short = 6
	Public Const cmMST_RESERVED1 As Short = 7
	Public Const cmMST_WAIT_PLSR As Short = 8
	Public Const cmMST_IN_RVSSPD As Short = 9
	Public Const cmMST_IN_INISPD As Short = 10
	Public Const cmMST_IN_ACC As Short = 11
	Public Const cmMST_IN_WORKSPD As Short = 12
	Public Const cmMST_IN_DEC As Short = 13
	Public Const cmMST_WAIT_INP As Short = 14
	Public Const cmMST_SPARE0 As Short = 15
	
	
	' Signal logic definition
	
	
	Public Const cmLOGIC_A As Short = 0
	'Normal open
	Public Const cmLOGIC_B As Short = 1
	'Normal close
	
	
	' Axis index definition
	
	Public Const cmX1 As Short = 0
	Public Const cmY1 As Short = 1
	Public Const cmZ1 As Short = 2
	Public Const cmU1 As Short = 3
	Public Const cmX2 As Short = 4
	Public Const cmY2 As Short = 5
	Public Const cmZ2 As Short = 6
	Public Const cmU2 As Short = 7
	
	
	' Definition for axes mask
	
	
	Public Const cmX1_MASK As Integer = &H1
	Public Const cmY1_MASK As Integer = &H2
	Public Const cmZ1_MASK As Integer = &H4
	Public Const cmU1_MASK As Integer = &H8
	
	Public Const cmX2_MASK As Integer = &H10
	Public Const cmY2_MASK As Integer = &H20
	Public Const cmZ2_MASK As Integer = &H40
	Public Const cmU2_MASK As Integer = &H80
	
	
	' Encoder and PA/PB input mode definition
	
	Public Const cmIMODE_AB1X As Short = 0
	Public Const cmIMODE_AB2X As Short = 1
	Public Const cmIMODE_AB4X As Short = 2
	Public Const cmIMODE_CWCCW As Short = 3
	Public Const cmIMODE_STEP As Short = 4
	
	
	' Command output mode definition
	
	Public Const cmOMODE_PDIR0 As Short = 0
	Public Const cmOMODE_PDIR1 As Short = 1
	Public Const cmOMODE_PDIR2 As Short = 2
	Public Const cmOMODE_PDIR3 As Short = 3
	Public Const cmOMODE_CWCCW0 As Short = 4
	Public Const cmOMODE_CWCCW1 As Short = 5
	Public Const cmOMODE_CCWCW0 As Short = 6
	Public Const cmOMODE_CCWCW1 As Short = 7
	
	
	' Control Mode
	
	Public Const cmCTRL_OPEN As Short = 0
	' Open loop control mode
	Public Const cmCTRL_SEMI_C As Short = 1
	' Semi-closed loop control mode (applied only to absolute in-position commands)
	Public Const cmCTRL_FULL_C As Short = 2
	' Full-closed loop control mode (this is not supported at current version)
	
	
	
	' (Linear)Operation direction
	
	Public Const cmDIR_N As Short = 0
	'(-)Dir
	Public Const cmDIR_P As Short = 1
	'(+)Dir
	
	
	' Counter name
	
	
	Public Const cmCNT_COMM As Short = 0
	'Command
	Public Const cmCNT_FEED As Short = 1
	'Feedback
	Public Const cmCNT_DEV As Short = 2
	'Deviation
	
	Public Const cmCNT_GEN As Short = 3
	'General
	Public Const cmCNT_REM As Short = 4
	'Remained
	
	
	' Speed mode index definition
	
	
	Public Const cmSMODE_KEEP As Short = -1
	' Keep previous setting
	Public Const cmSMODE_C As Short = 0
	'Constant
	Public Const cmSMODE_T As Short = 1
	'Trapeziodal
	Public Const cmSMODE_S As Short = 2
	'S-curve
	
	
	' Arc operation direction
	
	Public Const cmARC_CW As Short = 0
	Public Const cmARC_CCW As Short = 1
	
	
	' Compare Method
	
	Public Const cmDISABLE As Short = 0
	Public Const cmEQ_BIDIR As Short = 1
	Public Const cmEQ_PDIR As Short = 2
	Public Const cmEQ_NDIR As Short = 3
	Public Const cmLESS As Short = 4
	'Cnt<Data
	Public Const cmGREATER As Short = 5
	'Cnt>Data
	
	
	' Action when general comparator met the condition
	
	Public Const cmEVNT_ONLY As Short = 0
	Public Const cmEVNT_IS As Short = 1
	Public Const cmEVNT_DS As Short = 2
	Public Const cmEVNT_SPDCHG As Short = 3
	
	
	' Backlash/Slip correction mode
	
	Public Const cmCORR_DIS As Short = 0
	' Disable correction
	Public Const cmCORR_BACK As Short = 1
	' Backlash correction mode
	Public Const cmCORR_SLIP As Short = 2
	' Slip correction mode
	
	
	Public Const cmEXOPT_SET_USE_PREREG As Short = 0
	
	
	' Interrupt Handler Type
	
	
	Public Const cmIHT_MESSAGE As Short = 0
	Public Const cmIHT_EVENT As Short = 1
	Public Const cmIHT_CALLBACK As Short = 2
	
	
	' Interrupt Handler Type
	
	Public Const cmSTR_AXIS_NAME As Short = 0
	Public Const cmSTR_DIST_UNIT As Short = 1
	Public Const cmSTR_SPEED_UNIT As Short = 2
	
	
	' Sequence Mode
	
	Public Const cmSEQM_SKIP_RUN As Short = 0
	Public Const cmSEQM_WAIT_RUN As Short = 1
	
	
	' Map Type
	
	Public Const cmDMAP_MOTION As Short = 0
	Public Const cmDMAP_DIO As Short = 1
	Public Const cmDMAP_ALL As Short = 2
	
	
	' SetFilterAB 
	
	Public Const cmAB_ENC As Short = 0
	Public Const cmAB_PULSAR As Short = 1
	
	
	' Axis Capability ID
	
	
	Public Const cmCAPX_CMD_DIR As Short = 0
	' Command direction change function
	Public Const cmCAPX_EL_MAN_SET As Short = 1
	' -/+EL Manual control function
	Public Const cmCAPX_CMP_HIGH As Short = 2
	' High-speed Compare Output function
	
	
	Public Const cmHPCM_M0 As Short = 0
	' ORG(/EL/EZ) ȣ ߻  COMMAND & FEEDBACK ġ 0 ŬѴ.
	Public Const cmHPCM_M1 As Short = 1
	' ͸  Ϸϰ  COMMAND & FEEDBACK ġ  0 ŬѴ.
	Public Const cmHPCM_M2 As Short = 2
	' ͸  Ϸϰ  FEEDBACK ġ ״ ΰ COMMAND ġ FEEDBACK ġ ġŲ.
	
	
	' Sync mode
	
	Public Const cmSYNC_DISABLE As Short = 0
	Public Const cmSYNC_INT_SYNC As Short = 1
	Public Const cmSYNC_OTHER_STOP As Short = 2
	
	
	' TCmLmxStsId: cmmLmxGetSts() Լ ؼ о status ID  
	Public Const cmLMX_STARTED As Short = 0 ' Lmx  Ȱȭ Ǿ Ÿ status
	Public Const cmLMX_BUSY As Short = 1 ' Lmx   ̼   Ÿ status
	Public Const cmLMX_FREE_SPACE As Short = 2 ' Lmx   . ȯǴ  Ʈ  ƴ϶   ִ  ̴.
	Public Const cmLMX_RUN_ITEM_NO As Short = 3 '  ̼۵ǰ ְų  ̼۵ Item ȣ.
	Public Const cmLMX_RUN_ITEM_ID As Short = 4 '  ̼۵ǰ ְų  ̼۵ Item ̵(̵ cmmLmxSetNextItemId() Լ ؼ Ѵ)
	Public Const cmLMX_LAST_SET_ITEM_ID As Short = 5 '   Item ̵.
	'public const cmLMX_LAST_SET_ITEM_NO = 6  '   Item ̵[Ŀ ߰].
	
	' TCmLmxSeqMode: ̼۸ Ϸ ϴµ LMX Buffer ̹  ִ 쿡  ó
	'    ̵.
	' -. cmLMX_SEQM_SKIP_RUN: 'cmERR_LMX_ADD_ITEM_FAIL' ߻ϰ Լ ٷ ȯȴ.
	' -. cmLMX_SEQM_WAIT_RUN: LMX ۿ free space   ϰ ִٰ free space
	'     ϰ Լ ȯȴ.
	Public Const cmLMX_SEQM_SKIP_RUN As Short = 0
	Public Const cmLMX_SEQM_WAIT_RUN As Short = 1
	
	
	' Internal sync. conditions
	
	Public Const cmISYNC_ACC_STA As Short = 0
	' 0: at start of acceleration
	Public Const cmISYNC_ACC_END As Short = 1
	' 1: at end of acceleration
	Public Const cmISYNC_DEC_STA As Short = 2
	' 2: at start of deceleration
	Public Const cmISYNC_DEC_END As Short = 3
	' 3: at end of deceleration
	Public Const cmISYNC_SLN As Short = 4
	' 4: when (-)software limit met
	Public Const cmISYNC_SLP As Short = 5
	' 5: when (+)software limit met
	Public Const cmISYNC_GCMP As Short = 6
	' 6: when General Comparator condition is satisfied
	Public Const cmISYNC_TCMP As Short = 7
	' 7: when Trigger Comparator condition is satisfied
	
	
	'***********************************************************************************************
	
	'                                                               FUNCTION Prototype                                                                                              *
	
	'***********************************************************************************************
	
	' Interrupt Handler Callback Function Prototype
	
	' Informations of all actually installed motion devices
	
	' Informations of motion devices defined by user
	
	'------------------- DIO Device Informations -----------------------------------------------------------
	
	' Informations of a DIO device
	
	' Informations of all actually installed DIO devices
	
	' Informations of DIO devices defined by user
	
	'-------------------- MOTION CONFIGURATION ------------------------------------------------------------
	
	'------------------------------------------------------------------------------------------------------
	
	'--------------------------------- CME FILE STRUCTURE (ALL) --------------------------------------------
	
	'***********************************************************************************************
	
	'                                                                       ERROR CODE DEFINITIONs                                                                          *
	
	'***********************************************************************************************
	Public Const cmERR_NONE As Short = 0
	Public Const cmERR_MEM_ALLOC_FAIL As Short = -290
	' Memory allocation fail
	Public Const cmERR_GLOBAL_MEM_FAIL As Short = -292
	' Global memory allocation fail
	Public Const cmERR_ISR_CONNEC_FAIL As Short = -310
	' ISR registration fail
	Public Const cmERR_DIVIDE_BY_ZERO As Short = -400
	' Cause divide by zero error
	Public Const cmERR_WORNG_NUM_DATA As Short = -500
	' Number of data is too small or too big
	Public Const cmERR_VER_MISMATCH As Short = -600
	' Version(of file or device) mismatch
	Public Const cmERR_INVALID_DEVICE_ID As Short = -1010
	' Invalid device id > Load Device Ǵ SetDeviceId()...
	Public Const cmERR_INVALID_HANDLE As Short = -1020
	Public Const cmERR_UNSUPORTED_FUNC As Short = -1030
	Public Const cmERR_INVALID_PARAMETER As Short = -1101
	Public Const cmERR_INVALID_CHANNEL As Short = -1105
	Public Const cmERR_INVALID_INPUT_RANGE As Short = -1111
	' Invalid range value (AI, AO)
	Public Const cmERR_INVALID_FREQ_RANGE As Short = -1121
	' Invalid input or output frequency
	Public Const cmERR_FILE_CREATE_FAIL As Short = -1501
	' File create fail
	Public Const cmERR_FILE_OPEN_FAIL As Short = -1511
	' File open fail
	Public Const cmERR_FILE_READ_FAIL As Short = -1522
	' File reading fail
	Public Const cmERR_EVENT_CREATE_FAIL As Short = -1550
	' Event handle creation fail
	Public Const cmERR_INT_INSTANCE_FAIL As Short = -1560
	' Interrupt event instance creation fail
	Public Const cmERR_DITHREAD_CRE As Short = -1570
	' D/I state change monitor thread creation fail
	Public Const cmERR_BUFFER_SMALL As Short = -1580
	' Buffer size is too small
	Public Const cmERR_HIGH_TIMER_UNSUPP As Short = -1590
	' The installed hardware does not support a high-resolution performance counter (cmmUtlDelayMicroSec() function fails)
	Public Const cmERR_OUT_OF_RANGE As Short = -1600
	' The range of some parameter is out of range
	Public Const cmERR_ON_MOTION As Short = -5001
	Public Const cmERR_STOP_BY_SLP As Short = -5002
	' Abnormally stopped by positive soft limit
	Public Const cmERR_STOP_BY_SLN As Short = -5003
	' Abnormally stopped by negative soft limit
	Public Const cmERR_STOP_BY_CMP3 As Short = -5004
	' Abnormally stopped by comparator3
	Public Const cmERR_STOP_BY_CMP4 As Short = -5005
	' Abnormally stopped by comparator4
	Public Const cmERR_STOP_BY_CMP5 As Short = -5006
	' Abnormally stopped by comparator5
	Public Const cmERR_STOP_BY_ELP As Short = -5007
	' Abnormally stopped by (+) external limit
	Public Const cmERR_STOP_BY_ELN As Short = -5008
	' Abnormally stopped by (-) external limit
	Public Const cmERR_STOP_BY_ALM As Short = -5009
	' Abnormally stopped by alarm input signal
	Public Const cmERR_STOP_BY_CSTP As Short = -5010
	' Abnormally stopped by CSTP input signal
	Public Const cmERR_STOP_BY_CEMG As Short = -5011
	' Abnormally stopped by CEMG input signal
	Public Const cmERR_STOP_BY_SD As Short = -5012
	' Abnormally stopped by SD input signal
	Public Const cmERR_STOP_BY_DERROR As Short = -5013
	' Abnormally stopped by operation data error
	Public Const cmERR_STOP_BY_IP As Short = -5014
	' Abnormally stopped by other axis error during interpolation
	Public Const cmERR_STOP_BY_PO As Short = -5015
	' An overflow occurred in the PA/PB input buffer
	Public Const cmERR_STOP_BY_AO As Short = -5016
	' Out of range position counter during interpolation
	Public Const cmERR_STOP_BY_EE As Short = -5017
	' An EA/EB input error occurred (does not stop)
	Public Const cmERR_STOP_BY_PE As Short = -5018
	' An PA/PB input error occurred (does not stop)
	Public Const cmERR_STOP_BY_SLVERR As Short = -5019
	' Abnormally stopped because slave axis has been stopped
	Public Const cmERR_STOP_BY_SEMG As Short = -5020
	' Abnormally stopped by software emergency setting
	Public Const cmERR_MOT_MAOMODE As Short = -5110
	' Master output mode is not CW/CCW mode // Master/Slave ۽ÿ Master output尡 CW/CCW尡 ƴϴ.
	Public Const cmERR_MOT_SLAVE_SET As Short = -5120
	' Slave start fail (Motion state "Wait for Pulsar Input"  ʴ´.
	Public Const cmERR_SPEED_RANGE_OVER As Short = -5130
	Public Const cmERR_INVALID_SPEED_SET As Short = -5140
	' Speed setting value is not valid
	Public Const cmERR_INVALID_IXMAP As Short = -5150
	' Invalid interpolation map
	Public Const cmERR_INVALID_LMMAP As Short = -5160
	' Invalid List-Motion Map
	Public Const cmERR_MOT_SEQ_SKIPPED As Short = -5170
	' Motion command is skipped because the axis is already running.
	Public Const cmERR_CMPIX_INVALID_MAP As Short = -5180
	' Interpolated position compare output map is not valid
	Public Const cmERR_INVALID_ARC_POS As Short = -5190
	' Arc-interpolation position data is invalid
	Public Const cmERR_UNKNOWN As Short = -9999
	
	Public Const CME_FILE_NAME As String = "Default.cme2"
	Public Declare Function GetSystemDirectory Lib "kernel32"  Alias "GetSystemDirectoryA"(ByVal Path As String, ByVal cbBytes As Integer) As Integer
	
	'******************************************************************************
	'* [ Cmmsdk.h ]
	'* Header file for API fuctions in CMMSDK library
	'* - Update Data: 2008/04/21
	'* - Provider: COMIZOA Co., Ltd.
	'* - Phone: +82-42-936-6500~6
	'* - Fax  : +82-42-936-6507
	'* - URL  : http://www.comizoa.co.kr,  http://www.comizoa.com
	'*******************************************************************************
	'*******************************************************************************
	'*******************************************************************************************************
	'                                                               API FUNCTIONS                                                           *
	'*******************************************************************************************************
	''////////////////////////////////////////////////////////////////////////////////////////////////////
	' SetBit() :   Ư Ʈ  Ѵ. ũ̹Ƿ Լ ȣ  ʵʿ !
	' v: , n:bitȣ, s:氪(state)
	''////////////////////////////////////////////////////////////////////////////////////////////////////
	' GetBit() :   Ư Ʈ  ȯѴ. ũ̹Ƿ Լ ȣ  ʵʿ !
	' v: , n:bitȣ
	'====================== DLL LOAD/UNLOAD FUNCTIONS ============================================
	'====================== General FUNCTIONS ====================================================
	Public Declare Function cmmGnDeviceLoad Lib "Cmmsdk.dll" (ByVal IsResetDevice As Integer, ByRef NumAxes As Integer) As Integer
	
	Public Declare Function cmmGnDeviceUnload Lib "Cmmsdk.dll" () As Integer
	
	Public Declare Function cmmGnDeviceIsLoaded Lib "Cmmsdk.dll" (ByRef IsLoaded As Integer) As Integer
	
	Public Declare Function cmmGnDeviceReset Lib "Cmmsdk.dll" () As Integer
	
	Public Declare Function cmmGnInitFromFile Lib "Cmmsdk.dll" (ByVal szCmeFile As String) As Integer
	
	Public Declare Function cmmGnInitFromFile_MapOnly Lib "Cmmsdk.dll" (ByRef szCmeFile As String, ByVal MapType As Integer) As Integer
	
	Public Declare Function cmmGnSetServoOn Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Enable As Integer) As Integer
	
	Public Declare Function cmmGnGetServoOn Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Enable As Integer) As Integer
	
	Public Declare Function cmmGnSetAlarmRes Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal IsOn As Integer) As Integer
	
	Public Declare Function cmmGnGetAlarmRes Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef IsOn As Integer) As Integer
	
	Public Declare Function cmmGnPulseAlarmRes Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal IsOnPulse As Integer, ByVal dwDuration As Integer, ByVal IsWaitPulseEnd As Integer) As Integer
	
	Public Declare Function cmmGnSetSimulMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsSimulMode As Integer) As Integer
	
	Public Declare Function cmmGnGetSimulMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IsSimulMode As Integer) As Integer
	
	Public Declare Function cmmGnPutInternalSTA Lib "Cmmsdk.dll" (ByVal AxesMask As Integer) As Integer
	
	Public Declare Function cmmGnSetEmergency Lib "Cmmsdk.dll" (ByVal IsEnable As Integer, ByVal IsDecStop As Integer) As Integer
	
	Public Declare Function cmmGnGetEmergency Lib "Cmmsdk.dll" (ByRef IsEnabled As Integer) As Integer
	
	Public Declare Function cmmGnBitShift Lib "Cmmsdk.dll" (ByVal Value As Integer, ByVal ShiftOption As Integer, ByRef Result As Integer) As Integer
	
	'====================== Configuration FUNCTIONS ==============================================
	Public Declare Function cmmCfgSetMioProperty Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal PropId As Integer, ByVal PropVal As Integer) As Integer
	
	Public Declare Function cmmCfgGetMioProperty Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal PropId As Integer, ByRef PropVal As Integer) As Integer
	
	Public Declare Function cmmCfgSetFilter Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsEnable As Integer) As Integer
	
	Public Declare Function cmmCfgGetFilter Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IsEnabled As Integer) As Integer
	
	Public Declare Function cmmCfgSetFilterAB Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal Target As Integer, ByVal IsEnable As Integer) As Integer
	
	Public Declare Function cmmCfgGetFilterAB Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal Target As Integer, ByRef IsEnabled As Integer) As Integer
	
	Public Declare Function cmmCfgSetInMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal InputMode As Integer, ByVal IsReverse As Integer) As Integer
	
	Public Declare Function cmmCfgGetInMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef InputMode As Integer, ByRef IsReverse As Integer) As Integer
	
	Public Declare Function cmmCfgSetOutMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal OutputMode As Integer) As Integer
	
	Public Declare Function cmmCfgGetOutMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef OutputMode As Integer) As Integer
	
	Public Declare Function cmmCfgSetCtrlMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal CtrlMode As Integer) As Integer
	
	Public Declare Function cmmCfgGetCtrlMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef CtrlMode As Integer) As Integer
	
	Public Declare Function cmmCfgSetInOutRatio Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Ratio As Double) As Integer
	
	Public Declare Function cmmCfgGetInOutRatio Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Ratio As Double) As Integer
	
	Public Declare Function cmmCfgSetUnitDist Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal UnitDist As Double) As Integer
	
	Public Declare Function cmmCfgGetUnitDist Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef UnitDist As Double) As Integer
	
	Public Declare Function cmmCfgSetUnitSpeed Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal UnitSpeed As Double) As Integer
	
	Public Declare Function cmmCfgGetUnitSpeed Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef UnitSpeed As Double) As Integer
	
	Public Declare Function cmmCfgSetSpeedRange Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal MaxPPS As Double) As Integer
	
	Public Declare Function cmmCfgGetSpeedRange Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef MinPPS As Double, ByRef MaxPPS As Double) As Integer
	
	Public Declare Function cmmCfgSetSpeedPattern Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal SpeedMode As Integer, ByVal WorkSpeed As Double, ByVal Accel As Double, ByVal Decel As Double) As Integer
	
	Public Declare Function cmmCfgGetSpeedPattern Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef SpeedMode As Integer, ByRef WorkSpeed As Double, ByRef Accel As Double, ByRef Decel As Double) As Integer
	
	Public Declare Function cmmCfgSetActSpdCheck Lib "Cmmsdk.dll" (ByVal IsEnable As Integer, ByVal Interval As Integer) As Integer
	
	Public Declare Function cmmCfgGetActSpdCheck Lib "Cmmsdk.dll" (ByRef IsEnable As Integer, ByRef Interval As Integer) As Integer
	
	Public Declare Function cmmCfgSetSoftLimit Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsEnable As Integer, ByVal LimitN As Double, ByVal LimitP As Double) As Integer
	
	Public Declare Function cmmCfgGetSoftLimit Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IsEnable As Integer, ByRef LimitN As Double, ByRef LimitP As Double) As Integer
	
	Public Declare Function cmmCfgSetRingCntr Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal TargCntr As Integer, ByVal IsEnable As Integer, ByVal CntMax As Double) As Integer
	
	Public Declare Function cmmCfgGetRingCntr Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal TargCntr As Integer, ByRef IsEnable As Integer, ByRef CntMax As Double) As Integer
	
	Public Declare Function cmmCfgSetVelCorrRatio Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal fCorrRatio As Double) As Integer
	
	Public Declare Function cmmCfgGetVelCorrRatio Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef fCorrRatio As Double) As Integer
	
	Public Declare Function cmmCfgSetSeqMode Lib "Cmmsdk.dll" (ByVal SeqMode As Integer) As Integer
	
	Public Declare Function cmmCfgGetSeqMode Lib "Cmmsdk.dll" (ByRef SeqMode As Integer) As Integer
	
	Public Declare Function cmmCfgSetManExtLimit Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal IsSetELP As Integer, ByVal IsEnable As Integer, ByVal ManState As Integer) As Integer
	
	Public Declare Function cmmCfgGetManExtLimit Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal IsGetELP As Integer, ByRef IsEnable As Integer, ByRef ManState As Integer) As Integer
	
	'====================== HOME-RETURN FUNCTIONS ================================================
	Public Declare Function cmmHomeSetConfig Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal HomeMode As Integer, ByVal EzCount As Integer, ByVal EscDist As Double, ByVal Offset As Double) As Integer
	
	Public Declare Function cmmHomeGetConfig Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef HomeMode As Integer, ByRef EzCount As Integer, ByRef EscDist As Double, ByRef Offset As Double) As Integer
	
	Public Declare Function cmmHomeSetPosClrMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal PosClrMode As Integer) As Integer
	
	Public Declare Function cmmHomeGetPosClrMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef PosClrMode As Integer) As Integer
	
	Public Declare Function cmmHomeSetSpeedPattern Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal SpeedMode As Integer, ByVal Vel As Double, ByVal Accel As Double, ByVal Decel As Double, ByVal RevVel As Double) As Integer
	
	Public Declare Function cmmHomeGetSpeedPattern Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef SpeedMode As Integer, ByRef Vel As Double, ByRef Accel As Double, ByRef Decel As Double, ByRef RevVel As Double) As Integer
	
	Public Declare Function cmmHomeMoveStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Direction As Integer) As Integer
	
	Public Declare Function cmmHomeMove Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Direction As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmHomeMoveAll Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef DirList As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmHomeMoveAllStart Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef DirList As Integer) As Integer
	
	Public Declare Function cmmHomeGetSuccess Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IsSuccess As Integer) As Integer
	
	Public Declare Function cmmHomeSetSuccess Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsSuccess As Integer) As Integer
	
	Public Declare Function cmmHomeIsBusy Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IsBusy As Integer) As Integer
	
	Public Declare Function cmmHomeWaitDone Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsBlocking As Integer) As Integer
	
	'====================== Single Axis Move FUNCTIONS ===========================================
	Public Declare Function cmmSxSetSpeedRatio Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal SpeedMode As Integer, ByVal VelRatio As Double, ByVal AccRatio As Double, ByVal DecRatio As Double) As Integer
	
	Public Declare Function cmmSxGetSpeedRatio Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef SpeedMode As Integer, ByRef VelRatio As Double, ByRef AccRatio As Double, ByRef DecRatio As Double) As Integer
	
	Public Declare Function cmmSxMoveStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Distance As Double) As Integer
	
	Public Declare Function cmmSxMove Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Distance As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmSxMoveToStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Position As Double) As Integer
	
	Public Declare Function cmmSxMoveTo Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Position As Double, ByVal IsBlocking As Integer) As Integer
	
	'UPGRADE_NOTE: Dir was upgraded to Dir_Renamed. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Public Declare Function cmmSxVMoveStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Dir_Renamed As Integer) As Integer
	
	Public Declare Function cmmSxStop Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsWaitComplete As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmSxStopEmg Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmSxIsDone Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IsDone As Integer) As Integer
	
	Public Declare Function cmmSxWaitDone Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmSxGetTargetPos Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef Position As Double) As Integer
	
	Public Declare Function cmmSxOptSetIniSpeed Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IniSpeed As Double) As Integer
	
	Public Declare Function cmmSxOptGetIniSpeed Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IniSpeed As Double) As Integer
	
	Public Declare Function cmmSxSetCorrection Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal CorrMode As Integer, ByVal CorrAmount As Double, ByVal CorrVel As Double, ByVal CntrMask As Integer) As Integer
	
	Public Declare Function cmmSxGetCorrection Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef CorrMode As Integer, ByRef CorrAmount As Double, ByRef CorrVel As Double, ByRef CntrMask As Integer) As Integer
	
	Public Declare Function cmmSxOptSetSyncMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Mode As Integer, ByVal RefAxis As Integer, ByVal Condition As Integer) As Integer
	
	Public Declare Function cmmSxOptGetSyncMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Mode As Integer, ByRef RefAxis As Integer, ByRef Condition As Integer) As Integer
	
	Public Declare Function cmmSxOptSetSyncOut Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Mode As Integer, ByVal DoChan_local As Integer, ByVal DoLogic As Integer) As Integer
	
	Public Declare Function cmmSxOptGetSyncOut Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Mode As Integer, ByRef DoChan_local As Integer, ByRef DoLogic As Integer) As Integer
	
	Public Declare Function cmmSxOptSetRdpOffset Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal OffsetDist As Double) As Integer
	
	Public Declare Function cmmSxOptGetRdpOffset Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef OffsetDist As Double) As Integer
	
	'====================== Multiple Axes Move FUNCTIONS =========================================
	Public Declare Function cmmMxMove Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef DistList As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmMxVMoveStart Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef DirList As Integer) As Integer
	
	Public Declare Function cmmMxMoveStart Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef DistList As Double) As Integer
	
	Public Declare Function cmmMxMoveTo Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef PosList As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmMxMoveToStart Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef PosList As Double) As Integer
	
	Public Declare Function cmmMxStop Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByVal IsWaitComplete As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmMxStopEmg Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer) As Integer
	
	Public Declare Function cmmMxIsDone Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef IsDone As Integer) As Integer
	
	Public Declare Function cmmMxWaitDone Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer, ByVal IsBlocking As Integer) As Integer
	
	'====================== Interpolation Move FUNCTIONS =========================================
	Public Declare Function cmmIxMapAxes Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal MapMask1 As Integer, ByVal MapMask2 As Integer) As Integer
	
	Public Declare Function cmmIxSetSpeedPattern Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal IsVectorSpeed As Integer, ByVal SpeedMode As Integer, ByVal Vel As Double, ByVal Acc As Double, ByVal Dec As Double) As Integer
	
	Public Declare Function cmmIxGetSpeedPattern Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByRef IsVectorSpeed As Integer, ByRef SpeedMode As Integer, ByRef Vel As Double, ByRef Acc As Double, ByRef Dec As Double) As Integer
	
	Public Declare Function cmmIxLine Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByRef DistList As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxLineStart Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByRef DistList As Double) As Integer
	
	Public Declare Function cmmIxLineTo Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByRef PosList As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxLineToStart Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByRef PosList As Double) As Integer
	
	Public Declare Function cmmIxArcA Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal XCentOffset As Double, ByVal YCentOffset As Double, ByVal EndAngle As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxArcAStart Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal XCentOffset As Double, ByVal YCentOffset As Double, ByVal EndAngle As Double) As Integer
	
	Public Declare Function cmmIxArcATo Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal XCent As Double, ByVal YCent As Double, ByVal EndAngle As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxArcAToStart Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal XCent As Double, ByVal YCent As Double, ByVal EndAngle As Double) As Integer
	
	Public Declare Function cmmIxArcP Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal XCentOffset As Double, ByVal YCentOffset As Double, ByVal XEndPointDist As Double, ByVal YEndPointDist As Double, ByVal Direction As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxArcPStart Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal XCentOffset As Double, ByVal YCentOffset As Double, ByVal XEndPointDist As Double, ByVal YEndPointDist As Double, ByVal Direction As Integer) As Integer
	
	Public Declare Function cmmIxArcPTo Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal XCent As Double, ByVal YCent As Double, ByVal XEndPos As Double, ByVal YEndPos As Double, ByVal Direction As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxArcPToStart Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal XCent As Double, ByVal YCent As Double, ByVal XEndPos As Double, ByVal YEndPos As Double, ByVal Direction As Integer) As Integer
	
	Public Declare Function cmmIxArc3PStart Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal P2X As Double, ByVal P2Y As Double, ByVal P3X As Double, ByVal P3Y As Double, ByVal EndAngle As Double) As Integer
	
	Public Declare Function cmmIxArc3P Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal P2X As Double, ByVal P2Y As Double, ByVal P3X As Double, ByVal P3Y As Double, ByVal EndAngle As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxArc3PToStart Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal P2X As Double, ByVal P2Y As Double, ByVal P3X As Double, ByVal P3Y As Double, ByVal EndAngle As Double) As Integer
	
	Public Declare Function cmmIxArc3PTo Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal P2X As Double, ByVal P2Y As Double, ByVal P3X As Double, ByVal P3Y As Double, ByVal EndAngle As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxIsDone Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByRef IsDone As Integer) As Integer
	
	Public Declare Function cmmIxWaitDone Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxStop Lib "Cmmsdk.dll" (ByVal MapIndex As Integer, ByVal IsWaitComplete As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxStopEmg Lib "Cmmsdk.dll" (ByVal MapIndex As Integer) As Integer
	
	Public Declare Function cmmIxxHelOnceSetSpeed Lib "Cmmsdk.dll" (ByVal HelId As Integer, ByVal Master As Integer, ByVal SpeedMode As Integer, ByVal WorkSpeed As Double, ByVal Acc As Double, ByVal Dec As Double) As Integer
	
	Public Declare Function cmmIxxHelOnceGetSpeed Lib "Cmmsdk.dll" (ByVal HelId As Integer, ByRef SpeedMaster As Integer, ByRef SpeedMode As Integer, ByRef WorkSpeed As Double, ByRef Acc As Double, ByRef Dec As Double) As Integer
	
	Public Declare Function cmmIxxHelOnce Lib "Cmmsdk.dll" (ByVal HelId As Integer, ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef CoordList As Double, ByVal ArcAngle As Double, ByRef DistU As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmIxxHelOnceStart Lib "Cmmsdk.dll" (ByVal HelId As Integer, ByVal NumAxes As Integer, ByRef AxisList As Integer, ByRef CoordList As Double, ByVal ArcAngle As Double, ByRef DistU As Double) As Integer
	
	Public Declare Function cmmIxxSplineBuild Lib "Cmmsdk.dll" (ByRef InArray As Double, ByVal NumInArray As Integer, ByRef OutArray As Double, ByVal NumOutArray As Integer) As Integer
	
	'====================== External Switch Move FUNCTIONS =======================================
	Public Declare Function cmmExVMoveStart Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmExMoveStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Distance As Double) As Integer
	
	Public Declare Function cmmExMoveToStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Position As Double) As Integer
	
	'====================== Manual Pulsar FUNCTIONS ==============================================
	Public Declare Function cmmPlsrSetInMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal InputMode As Integer, ByVal IsInverse As Integer) As Integer
	
	Public Declare Function cmmPlsrGetInMode Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef InputMode As Integer, ByRef IsInverse As Integer) As Integer
	
	Public Declare Function cmmPlsrSetGain Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal GainFactor As Integer, ByVal DivFactor As Integer) As Integer
	
	Public Declare Function cmmPlsrGetGain Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef GainFactor As Integer, ByRef DivFactor As Integer) As Integer
	
	Public Declare Function cmmPlsrHomeMoveStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal HomeType As Integer) As Integer
	
	Public Declare Function cmmPlsrMoveStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Distance As Double) As Integer
	
	Public Declare Function cmmPlsrMove Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Distance As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmPlsrMoveToStart Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Position As Double) As Integer
	
	Public Declare Function cmmPlsrMoveTo Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Position As Double, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmPlsrVMoveStart Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmPlsrIsActive Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef IsActive As Integer) As Integer
	
	'====================== MASTER/SLAVE FUNCTIONS ===============================================
	Public Declare Function cmmMsRegisterSlave Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal MaxSpeed As Double, ByVal IsInverse As Integer) As Integer
	
	Public Declare Function cmmMsUnregisterSlave Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmMsCheckSlaveState Lib "Cmmsdk.dll" (ByVal SlaveAxis As Integer, ByRef SlaveState As Integer) As Integer
	
	Public Declare Function cmmMsGetMasterAxis Lib "Cmmsdk.dll" (ByVal SlaveAxis As Integer, ByRef MasterAxis As Integer) As Integer
	
	'====================== Overriding FUNCTIONS =================================================
	Public Declare Function cmmOverrideSpeedSet Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmOverrideSpeedSetAll Lib "Cmmsdk.dll" (ByVal NumAxes As Integer, ByRef AxisList As Integer) As Integer
	
	Public Declare Function cmmOverrideMove Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal NewDistance As Double, ByRef IsIgnored As Integer) As Integer
	
	Public Declare Function cmmOverrideMoveTo Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal NewPosition As Double, ByRef IsIgnored As Integer) As Integer
	
	'====================== LIST-MOTION FUNCTIONS ================================================
	Public Declare Function cmmLmMapAxes Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal MapMask1 As Integer, ByVal MapMask2 As Integer) As Integer
	
	Public Declare Function cmmLmBeginList Lib "Cmmsdk.dll" (ByVal LmIndex As Integer) As Integer
	
	Public Declare Function cmmLmEndList Lib "Cmmsdk.dll" (ByVal LmIndex As Integer) As Integer
	
	Public Declare Function cmmLmStartMotion Lib "Cmmsdk.dll" (ByVal LmIndex As Integer) As Integer
	
	Public Declare Function cmmLmAbortMotion Lib "Cmmsdk.dll" (ByVal LmIndex As Integer) As Integer
	
	Public Declare Function cmmLmIsDone Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByRef IsDone As Integer) As Integer
	
	Public Declare Function cmmLmWaitDone Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal IsBlocking As Integer) As Integer
	
	Public Declare Function cmmLmCurSequence Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByRef SeqIndex As Integer) As Integer
	
	Public Declare Function cmmLmImmediacySet Lib "Cmmsdk.dll" (ByVal LmIndex As Integer) As Integer
	
	Public Declare Function cmmLmDoPutOne Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal hDoDevice As Integer, ByVal Channel As Integer, ByVal OutState As Integer) As Integer
	
	Public Declare Function cmmLmDoPutMulti Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal hDoDevice As Integer, ByVal ChannelGroup As Integer, ByVal Mask As Integer, ByVal OutStates As Integer) As Integer
	
	Public Declare Function cmmLmDoPulseOne Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal hDoDevice As Integer, ByVal Channel As Integer, ByVal OutState As Integer, ByVal Duration As Integer) As Integer
	
	Public Declare Function cmmLmDoPulseMulti Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal hDoDevice As Integer, ByVal ChannelGroup As Integer, ByVal Mask As Integer, ByVal OutStates As Integer, ByVal Duration As Integer) As Integer
	
	'====================== ° FUNCTIONS ===================================================
	Public Declare Function cmmStSetCount Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Target As Integer, ByVal Count As Integer) As Integer
	
	Public Declare Function cmmStGetCount Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Source As Integer, ByRef Count As Integer) As Integer
	
	Public Declare Function cmmStSetPosition Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Target As Integer, ByVal Position As Double) As Integer
	
	Public Declare Function cmmStGetPosition Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Source As Integer, ByRef Position As Double) As Integer
	
	Public Declare Function cmmStGetSpeed Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Source As Integer, ByRef Speed As Double) As Integer
	
	Public Declare Function cmmStReadMotionState Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef MotStates As Integer) As Integer
	
	Public Declare Function cmmStReadMioStatuses Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef MioStates As Integer) As Integer
	
	Public Declare Function cmmStGetMstString Lib "Cmmsdk.dll" (ByVal MstCode As Integer, ByRef Buffer As Byte, ByVal BufferLen As Integer) As Integer
	
	'====================== INTERRUPT FUNCTIONS ==================================================
	Public Declare Function cmmIntSetMask Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Mask As Integer) As Integer
	
	Public Declare Function cmmIntGetMask Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Mask As Integer) As Integer
	
	'UPGRADE_ISSUE: Declaring a parameter 'As Any' is not supported. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="FAE78A8D-8978-4FD4-8208-5B7324A8F795"'
    Public Declare Function cmmIntHandlerSetup Lib "Cmmsdk.dll" (ByVal HandlerType As Integer, ByVal Handler As Integer, ByVal nMessage As Integer, ByVal lParam As Int32) As Integer
	
	Public Declare Function cmmIntHandlerEnable Lib "Cmmsdk.dll" (ByVal IsEnable As Integer) As Integer
	
	Public Declare Function cmmIntReadFlag Lib "Cmmsdk.dll" (ByRef IntFlag1 As Integer, ByRef IntFlag2 As Integer) As Integer
	
	Public Declare Function cmmIntReadErrorStatus Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef ErrState As Integer) As Integer
	
	Public Declare Function cmmIntReadEventStatus Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef EventState As Integer) As Integer
	
	'====================== LATCH FUNCTIONS =======================================================
	Public Declare Function cmmLtcIsLatched Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IsLatched As Integer) As Integer
	
	Public Declare Function cmmLtcReadLatch Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Counter As Integer, ByRef LatchedPos As Double) As Integer
	
	Public Declare Function cmmLtcQue_SetCfg Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal QueSize As Integer, ByVal LtcTargCntr As Integer) As Integer
	
	Public Declare Function cmmLtcQue_GetCfg Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef QueSize As Integer, ByRef LtcTargCntr As Integer) As Integer
	
	Public Declare Function cmmLtcQue_SetEnable Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsEnabled As Integer) As Integer
	
	Public Declare Function cmmLtcQue_GetEnable Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef IsEnabled As Integer) As Integer
	
	Public Declare Function cmmLtcQue_GetItemCount Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef LtcItemCount As Integer) As Integer
	
	Public Declare Function cmmLtcQue_ResetItemCount Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmLtcQue_Deque Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef LtcData As Double) As Integer
	
	Public Declare Function cmmLtcQue_PeekAt Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Index As Integer, ByRef LtcData As Double) As Integer
	
	'====================== Position Compare FUNCTIONS ===========================================
	Public Declare Function cmmCmpErrSetConfig Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Tolerance As Double, ByVal IsEnable As Integer) As Integer
	
	Public Declare Function cmmCmpErrGetConfig Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Tolerance As Double, ByRef IsEnabled As Integer) As Integer
	
	Public Declare Function cmmCmpGenSetConfig Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal CmpSrc As Integer, ByVal CmpMethod As Integer, ByVal CmpAction As Integer, ByVal CmpData As Double) As Integer
	
	Public Declare Function cmmCmpGenGetConfig Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef CmpSrc As Integer, ByRef CmpMethod As Integer, ByRef CmpAction As Integer, ByRef CmpData As Integer) As Integer
	
	Public Declare Function cmmCmpTrgSetConfig Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal CmpSrc As Integer, ByVal CmpMethod As Integer) As Integer
	
	Public Declare Function cmmCmpTrgGetConfig Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef CmpSrc As Integer, ByRef CmpMethod As Integer) As Integer
	
	Public Declare Function cmmCmpTrgSetOneData Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Data As Double) As Integer
	
	Public Declare Function cmmCmpTrgGetCurData Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Data As Double) As Integer
	
	Public Declare Function cmmCmpTrgContRegTable Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Buffer As Double, ByVal NumData As Integer) As Integer
	
	Public Declare Function cmmCmpTrgContBuildTable Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal StartData As Double, ByVal Interval As Double, ByVal NumData As Integer) As Integer
	
	Public Declare Function cmmCmpTrgContStart Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmCmpTrgContStop Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmCmpTrgContIsActive Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef IsActive As Integer) As Integer
	
	Public Declare Function cmmCmpTrgHigh_WriteData Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal CMPH_No As Integer, ByVal IniPos As Double, ByVal Interval As Double) As Integer
	
	Public Declare Function cmmCmpTrgHigh_ReadData Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef CMPH_No As Integer, ByRef IniPos As Double, ByRef Interval As Double) As Integer
	
	Public Declare Function cmmCmpTrgHigh_Start Lib "Cmmsdk.dll" (ByVal Channel As Integer) As Integer
	
	Public Declare Function cmmCmpTrgHigh_Stop Lib "Cmmsdk.dll" (ByVal Channel As Integer) As Integer
	
	Public Declare Function cmmCmpTrgHigh_Check Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef IsActive As Integer, ByRef OutCount As Integer) As Integer
	
	'
	'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_SetMap)    (long MapIdx, long Axis_X, long Axis_Y, long DoChan);
	'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_GetMap)    (long MapIdx, long *Axis_X, long *Axis_Y, long *DoChan, long *IsValid);
	'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_Start)     (long MapIdx, double PosArray_X[], double PosArray_Y[], long SrcSelArray[], long ArraySize);
	'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_Stop)      (long MapIdx);
	'CMM_EXTERN long        (WINAPI *cmmCmpTrgIx_GetState)  (long MapIdx, long *CmpOutCnt, long *IsActive);
	'
	'
	'====================== Digital In/Out FUNCTIONS =============================================
	Public Declare Function cmmDiSetInputLogic Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal InputLogic As Integer) As Integer
	
	Public Declare Function cmmDiGetInputLogic Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef InputLogic As Integer) As Integer
	
	Public Declare Function cmmDiGetOne Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef InputState As Integer) As Integer
	
	Public Declare Function cmmDiGetMulti Lib "Cmmsdk.dll" (ByVal IniChannel As Integer, ByVal NumChannels As Integer, ByRef InputStates As Integer) As Integer
	
	Public Declare Function cmmDiGetOneF Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal CutoffTime_us As Integer, ByRef InputState As Integer) As Integer
	
	Public Declare Function cmmDiGetMultiF Lib "Cmmsdk.dll" (ByVal IniChannel As Integer, ByVal NumChannels As Integer, ByVal CutoffTime_us As Integer, ByRef InputStates As Integer) As Integer
	
	Public Declare Function cmmDoSetOutputLogic Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal OutputLogic As Integer) As Integer
	
	Public Declare Function cmmDoGetOutputLogic Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef OutputLogic As Integer) As Integer
	
	Public Declare Function cmmDoPutOne Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal OutState As Integer) As Integer
	
	Public Declare Function cmmDoGetOne Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByRef OutState As Integer) As Integer
	
	Public Declare Function cmmDoPulseOne Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal IsOnPulse As Integer, ByVal dwDuration As Integer, ByVal IsWaitPulseEnd As Integer) As Integer
	
	Public Declare Function cmmDoPutMulti Lib "Cmmsdk.dll" (ByVal IniChannel As Integer, ByVal NumChannels As Integer, ByVal OutStates As Integer) As Integer
	
	Public Declare Function cmmDoGetMulti Lib "Cmmsdk.dll" (ByVal IniChannel As Integer, ByVal NumChannels As Integer, ByRef InputStates As Integer) As Integer
	
	Public Declare Function cmmDoPulseMulti Lib "Cmmsdk.dll" (ByVal IniChannel As Integer, ByVal NumChannels As Integer, ByVal OutStates As Integer, ByVal dwDuration As Integer, ByVal IsWaitPulseEnd As Integer) As Integer
	
	'====================== Advanced FUNCTIONS ===================================================
	Public Declare Function cmmAdvGetNumAvailAxes Lib "Cmmsdk.dll" (ByRef NumAxes As Integer) As Integer
	
	Public Declare Function cmmAdvGetNumDefinedAxes Lib "Cmmsdk.dll" (ByRef NumAxes As Integer) As Integer
	
	Public Declare Function cmmAdvGetNumAvailDioChan Lib "Cmmsdk.dll" (ByVal IsInputChannel As Integer, ByRef NumChannels As Integer) As Integer
	
	Public Declare Function cmmAdvGetNumDefinedDioChan Lib "Cmmsdk.dll" (ByVal IsInputChannel As Integer, ByRef NumChannels As Integer) As Integer
	
	Public Declare Function cmmAdvGetMotDeviceId Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef DeviceId As Integer) As Integer
	
	Public Declare Function cmmAdvGetMotDevInstance Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef DevInstance As Integer) As Integer
	
	Public Declare Function cmmAdvGetDioDeviceId Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsInputChannel As Integer, ByRef DeviceId As Integer) As Integer
	
	Public Declare Function cmmAdvGetDioDevInstance Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsInputChannel As Integer, ByRef DevInstance As Integer) As Integer
	
	Public Declare Function cmmAdvGetDeviceHandle Lib "Cmmsdk.dll" (ByVal DeviceId As Integer, ByVal DevInstance As Integer, ByRef DevHandle As Integer) As Integer
	
	Public Declare Function cmmAdvWriteMainSpace Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Addr As Integer, ByVal Value As Integer) As Integer
	
	Public Declare Function cmmAdvReadMainSpace Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Addr As Integer, ByRef Value As Integer) As Integer
	
	Public Declare Function cmmAdvWriteRegister Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal RegisterNo As Integer, ByVal RegVal As Integer) As Integer
	
	Public Declare Function cmmAdvReadRegister Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal RegisterNo As Integer, ByRef RegVal As Integer) As Integer
	
	Public Declare Function cmmAdvGetMioCfg1Dword Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByRef Mio1Dword As Integer) As Integer
	
	Public Declare Function cmmAdvSetMioCfg1Dword Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal Mio1Dword As Integer) As Integer
	
	Public Declare Function cmmAdvSetToolboxMode Lib "Cmmsdk.dll" (ByVal EnInterrupt As Integer) As Integer
	
	Public Declare Function cmmAdvGetString Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal StringID As Integer, ByRef szBuffer As Byte) As Integer
	
	Public Declare Function cmmAdvErcOut Lib "Cmmsdk.dll" (ByVal Axis As Integer, ByVal IsWaitOff As Integer) As Integer
	
	Public Declare Function cmmAdvErcReset Lib "Cmmsdk.dll" (ByVal Axis As Integer) As Integer
	
	Public Declare Function cmmAdvSetExtOptions Lib "Cmmsdk.dll" (ByVal OptionId As Integer, ByVal lParam1 As Integer, ByVal lParam2 As Integer, ByVal fParam1 As Double, ByVal fParam2 As Double) As Integer
	
	'CMM_EXTERN long (WINAPI *cmmAdvEnumMotDevices) (TMotDevEnum *EnumBuffer);
	
	'CMM_EXTERN long (WINAPI *cmmAdvGetMotDevMap)   (TMotDevMap *MapBuffer);
	
	'CMM_EXTERN long (WINAPI *cmmAdvEnumDioDevices) (TDioDevEnum *EnumBuffer);
	
	'CMM_EXTERN long (WINAPI *cmmAdvGetDioDevMap)   (TDioDevMap *MapBuffer);
	
	'CMM_EXTERN long (WINAPI *cmmAdvInitFromCmeBuffer) (TCmeData_V2 *pCmeBuffer);
	
	'CMM_EXTERN long (WINAPI *cmmAdvInitFromCmeBuffer_MapOnly) (TCmeData_V2 *pCmeBuffer, int nMapType);
	
	Public Declare Function cmmAdvGetLatestCmeFile Lib "Cmmsdk.dll" (ByRef szCmeFile As String) As Integer
	
	Public Declare Function cmmAdvGetAxisCapability Lib "Cmmsdk.dll" (ByVal Channel As Integer, ByVal CapId As Integer, ByRef CapBuffer As Integer) As Integer
	
	'====================== DEBUG-LOGGING FUNCTIONS ==============================================
	Public Declare Function cmmDlogSetup Lib "Cmmsdk.dll" (ByVal Level As Integer, ByRef szLogFile As String) As Integer
	
	Public Declare Function cmmDlogAddComment Lib "Cmmsdk.dll" (ByRef szComment As String) As Integer
	
	Public Declare Function cmmDlogGetCurLevel Lib "Cmmsdk.dll" (ByRef CurLevel As Integer) As Integer
	
	Public Declare Function cmmDlogGetCurFilePath Lib "Cmmsdk.dll" (ByRef szFilePath As String) As Integer
	
	'====================== ERROR HANDLING FUNCTIONS =============================================
	Public Declare Function cmmErrGetLastCode Lib "Cmmsdk.dll" (ByRef ErrorCode As Integer) As Integer
	
	Public Declare Function cmmErrParseAxis Lib "Cmmsdk.dll" (ByVal ErrorCode As Integer) As Integer
	
	Public Declare Function cmmErrParseReason Lib "Cmmsdk.dll" (ByVal ErrorCode As Integer) As Integer
	
	Public Declare Function cmmErrGetString Lib "Cmmsdk.dll" (ByVal ErrorCode As Integer, ByRef Buffer As String, ByVal BufferLen As Integer) As Integer
	
	Public Declare Function cmmErrShowLast Lib "Cmmsdk.dll" (ByVal ParentWnd As Integer) As Integer
	
	Public Declare Function cmmErrSetSkipShowMessage Lib "Cmmsdk.dll" (ByVal IsSkip As Integer) As Integer
	
	Public Declare Function cmmErrGetSkipShowMessage Lib "Cmmsdk.dll" (ByRef IsSkip As Integer) As Integer
	
	Public Declare Function cmmErrSetEnableAutoMessage Lib "Cmmsdk.dll" (ByVal Enable As Integer) As Integer
	
	Public Declare Function cmmErrGetEnableAutoMessage Lib "Cmmsdk.dll" (ByRef Enabled As Integer) As Integer
	
	'====================== Utility FUNCTIONS ===================================================
	Public Declare Function cmmUtlProcessWndMsgS Lib "Cmmsdk.dll" (ByVal WndHandle As Integer, ByRef IsEmpty As Integer) As Integer
	
	Public Declare Function cmmUtlProcessWndMsgM Lib "Cmmsdk.dll" (ByVal WndHandle As Integer, ByVal TimeOut As Integer, ByRef IsTimeOuted As Integer) As Integer
	
	Public Declare Function cmmUtlReadUserTable Lib "Cmmsdk.dll" (ByVal hDevice As Integer, ByVal nAddress As Integer, ByVal nSize As Integer, ByRef pBuffer As String) As Integer
	
	Public Declare Function cmmUtlWriteUserTable Lib "Cmmsdk.dll" (ByVal hDevice As Integer, ByVal nAddress As Integer, ByVal nSize As Integer, ByRef pBuffer As String) As Integer
	
	Public Declare Function cmmUtlDelayMicroSec Lib "Cmmsdk.dll" (ByVal Delay_us As Integer) As Integer
	
	'====================== Extended List Motion FUNCTIONS ======================================
	Public Declare Function cmmLmxStart Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal AxisMask1 As Integer, ByVal AxisMask2 As Integer) As Integer
	
	Public Declare Function cmmLmxPause Lib "Cmmsdk.dll" (ByVal LmIndex As Integer) As Integer
	
	Public Declare Function cmmLmxResume Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal IsClearQue As Integer) As Integer
	
	Public Declare Function cmmLmxEnd Lib "Cmmsdk.dll" (ByVal LmIndex As Integer) As Integer
	
	Public Declare Function cmmLmxSetSeqMode Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal SeqMode As Integer) As Integer
	
	Public Declare Function cmmLmxGetSeqMode Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal SeqMode As Integer) As Integer
	
	Public Declare Function cmmLmxSetNextItemId Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal SeqId As Integer) As Integer
	
	Public Declare Function cmmLmxGetNextItemId Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByRef SeqId As Integer) As Integer
	
	Public Declare Function cmmLmxGetSts Lib "Cmmsdk.dll" (ByVal LmIndex As Integer, ByVal LmxStsId As Integer, ByRef LmxStsVal As Integer) As Integer
End Module